///////////////////////////////////////////////////////////
//  Copyright (c) 1995/2006 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /    Vendor      : Xilinx 
// \  \    \/     Version : 10.1
//  \  \          Description : Xilinx Functional Simulation Library Component
//  /  /                        PCI Express
// /__/   /\      Filename    : PCIE_EP.v
// \  \  /  \     Timestamp   : Thu Dec 8 2005   
//  \__\/\__ \                    
//                                 
//  Revision:
//  CR#421379 - 08/14/06 - Initial version.
//            - 10/26/06 - Remove in_delay, out_delay localparam
//  CR#430518 - 12/05/06 - Add LLKRXDSTCONTREQN
//  CR#435993 - 03/13/07 - Add LLKTXCONFIGREADYN
//  End Revision
///////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module PCIE_EP (
	BUSMASTERENABLE,
	CRMDOHOTRESETN,
	CRMPWRSOFTRESETN,
	DLLTXPMDLLPOUTSTANDING,
	INTERRUPTDISABLE,
	IOSPACEENABLE,
	L0CFGLOOPBACKACK,
	L0COMPLETERID,
	L0DLLERRORVECTOR,
	L0DLLRXACKOUTSTANDING,
	L0DLLTXNONFCOUTSTANDING,
	L0DLLTXOUTSTANDING,
	L0DLLVCSTATUS,
	L0DLUPDOWN,
	L0FIRSTCFGWRITEOCCURRED,
	L0LTSSMSTATE,
	L0MACENTEREDL0,
	L0MACLINKTRAINING,
	L0MACLINKUP,
	L0MACNEGOTIATEDLINKWIDTH,
	L0MACNEWSTATEACK,
	L0MACRXL0SSTATE,
	L0MSIENABLE0,
	L0MULTIMSGEN0,
	L0PMEACK,
	L0PMEEN,
	L0PMEREQOUT,
	L0PWRL1STATE,
	L0PWRL23READYSTATE,
	L0PWRSTATE0,
	L0PWRTURNOFFREQ,
	L0PWRTXL0SSTATE,
	L0RXDLLPM,
	L0RXDLLPMTYPE,
	L0RXMACLINKERROR,
	L0STATSCFGOTHERRECEIVED,
	L0STATSCFGOTHERTRANSMITTED,
	L0STATSCFGRECEIVED,
	L0STATSCFGTRANSMITTED,
	L0STATSDLLPRECEIVED,
	L0STATSDLLPTRANSMITTED,
	L0STATSOSRECEIVED,
	L0STATSOSTRANSMITTED,
	L0STATSTLPRECEIVED,
	L0STATSTLPTRANSMITTED,
	L0UNLOCKRECEIVED,
	LLKRXCHCOMPLETIONAVAILABLEN,
	LLKRXCHNONPOSTEDAVAILABLEN,
	LLKRXCHPOSTEDAVAILABLEN,
	LLKRXDATA,
	LLKRXEOFN,
	LLKRXEOPN,
	LLKRXPREFERREDTYPE,
	LLKRXSOFN,
	LLKRXSOPN,
	LLKRXSRCLASTREQN,
	LLKRXSRCRDYN,
	LLKRXVALIDN,
	LLKTCSTATUS,
	LLKTXCHANSPACE,
	LLKTXCHCOMPLETIONREADYN,
	LLKTXCHNONPOSTEDREADYN,
	LLKTXCHPOSTEDREADYN,
	LLKTXCONFIGREADYN,
	LLKTXDSTRDYN,
	MAXPAYLOADSIZE,
	MAXREADREQUESTSIZE,
	MEMSPACEENABLE,
	MGMTPSO,
	MGMTRDATA,
	MGMTSTATSCREDIT,
	MIMDLLBRADD,
	MIMDLLBREN,
	MIMDLLBWADD,
	MIMDLLBWDATA,
	MIMDLLBWEN,
	MIMRXBRADD,
	MIMRXBREN,
	MIMRXBWADD,
	MIMRXBWDATA,
	MIMRXBWEN,
	MIMTXBRADD,
	MIMTXBREN,
	MIMTXBWADD,
	MIMTXBWDATA,
	MIMTXBWEN,
	PARITYERRORRESPONSE,
	PIPEDESKEWLANESL0,
	PIPEDESKEWLANESL1,
	PIPEDESKEWLANESL2,
	PIPEDESKEWLANESL3,
	PIPEDESKEWLANESL4,
	PIPEDESKEWLANESL5,
	PIPEDESKEWLANESL6,
	PIPEDESKEWLANESL7,
	PIPEPOWERDOWNL0,
	PIPEPOWERDOWNL1,
	PIPEPOWERDOWNL2,
	PIPEPOWERDOWNL3,
	PIPEPOWERDOWNL4,
	PIPEPOWERDOWNL5,
	PIPEPOWERDOWNL6,
	PIPEPOWERDOWNL7,
	PIPERESETL0,
	PIPERESETL1,
	PIPERESETL2,
	PIPERESETL3,
	PIPERESETL4,
	PIPERESETL5,
	PIPERESETL6,
	PIPERESETL7,
	PIPERXPOLARITYL0,
	PIPERXPOLARITYL1,
	PIPERXPOLARITYL2,
	PIPERXPOLARITYL3,
	PIPERXPOLARITYL4,
	PIPERXPOLARITYL5,
	PIPERXPOLARITYL6,
	PIPERXPOLARITYL7,
	PIPETXCOMPLIANCEL0,
	PIPETXCOMPLIANCEL1,
	PIPETXCOMPLIANCEL2,
	PIPETXCOMPLIANCEL3,
	PIPETXCOMPLIANCEL4,
	PIPETXCOMPLIANCEL5,
	PIPETXCOMPLIANCEL6,
	PIPETXCOMPLIANCEL7,
	PIPETXDATAKL0,
	PIPETXDATAKL1,
	PIPETXDATAKL2,
	PIPETXDATAKL3,
	PIPETXDATAKL4,
	PIPETXDATAKL5,
	PIPETXDATAKL6,
	PIPETXDATAKL7,
	PIPETXDATAL0,
	PIPETXDATAL1,
	PIPETXDATAL2,
	PIPETXDATAL3,
	PIPETXDATAL4,
	PIPETXDATAL5,
	PIPETXDATAL6,
	PIPETXDATAL7,
	PIPETXDETECTRXLOOPBACKL0,
	PIPETXDETECTRXLOOPBACKL1,
	PIPETXDETECTRXLOOPBACKL2,
	PIPETXDETECTRXLOOPBACKL3,
	PIPETXDETECTRXLOOPBACKL4,
	PIPETXDETECTRXLOOPBACKL5,
	PIPETXDETECTRXLOOPBACKL6,
	PIPETXDETECTRXLOOPBACKL7,
	PIPETXELECIDLEL0,
	PIPETXELECIDLEL1,
	PIPETXELECIDLEL2,
	PIPETXELECIDLEL3,
	PIPETXELECIDLEL4,
	PIPETXELECIDLEL5,
	PIPETXELECIDLEL6,
	PIPETXELECIDLEL7,
	SERRENABLE,
	URREPORTINGENABLE,

	AUXPOWER,
	COMPLIANCEAVOID,
	CRMCORECLK,
	CRMCORECLKDLO,
	CRMCORECLKRXO,
	CRMCORECLKTXO,
	CRMLINKRSTN,
	CRMMACRSTN,
	CRMMGMTRSTN,
	CRMNVRSTN,
	CRMURSTN,
	CRMUSERCFGRSTN,
	CRMUSERCLK,
	CRMUSERCLKRXO,
	CRMUSERCLKTXO,
	L0CFGDISABLESCRAMBLE,
	L0CFGLOOPBACKMASTER,
	L0LEGACYINTFUNCT0,
	L0MSIREQUEST0,
	L0PACKETHEADERFROMUSER,
	L0PMEREQIN,
	L0SETCOMPLETERABORTERROR,
	L0SETCOMPLETIONTIMEOUTCORRERROR,
	L0SETCOMPLETIONTIMEOUTUNCORRERROR,
	L0SETDETECTEDCORRERROR,
	L0SETDETECTEDFATALERROR,
	L0SETDETECTEDNONFATALERROR,
	L0SETUNEXPECTEDCOMPLETIONCORRERROR,
	L0SETUNEXPECTEDCOMPLETIONUNCORRERROR,
	L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR,
	L0SETUNSUPPORTEDREQUESTOTHERERROR,
	L0SETUSERDETECTEDPARITYERROR,
	L0SETUSERMASTERDATAPARITY,
	L0SETUSERRECEIVEDMASTERABORT,
	L0SETUSERRECEIVEDTARGETABORT,
	L0SETUSERSIGNALLEDTARGETABORT,
	L0SETUSERSYSTEMERROR,
	L0TRANSACTIONSPENDING,
	LLKRXCHFIFO,
	LLKRXCHTC,
	LLKRXDSTCONTREQN,	
	LLKRXDSTREQN,
	LLKTXCHFIFO,
	LLKTXCHTC,
	LLKTXDATA,
	LLKTXENABLEN,
	LLKTXEOFN,
	LLKTXEOPN,
	LLKTXSOFN,
	LLKTXSOPN,
	LLKTXSRCDSCN,
	LLKTXSRCRDYN,
	MGMTADDR,
	MGMTBWREN,
	MGMTRDEN,
	MGMTSTATSCREDITSEL,
	MGMTWDATA,
	MGMTWREN,
	MIMDLLBRDATA,
	MIMRXBRDATA,
	MIMTXBRDATA,
	PIPEPHYSTATUSL0,
	PIPEPHYSTATUSL1,
	PIPEPHYSTATUSL2,
	PIPEPHYSTATUSL3,
	PIPEPHYSTATUSL4,
	PIPEPHYSTATUSL5,
	PIPEPHYSTATUSL6,
	PIPEPHYSTATUSL7,
	PIPERXCHANISALIGNEDL0,
	PIPERXCHANISALIGNEDL1,
	PIPERXCHANISALIGNEDL2,
	PIPERXCHANISALIGNEDL3,
	PIPERXCHANISALIGNEDL4,
	PIPERXCHANISALIGNEDL5,
	PIPERXCHANISALIGNEDL6,
	PIPERXCHANISALIGNEDL7,
	PIPERXDATAKL0,
	PIPERXDATAKL1,
	PIPERXDATAKL2,
	PIPERXDATAKL3,
	PIPERXDATAKL4,
	PIPERXDATAKL5,
	PIPERXDATAKL6,
	PIPERXDATAKL7,
	PIPERXDATAL0,
	PIPERXDATAL1,
	PIPERXDATAL2,
	PIPERXDATAL3,
	PIPERXDATAL4,
	PIPERXDATAL5,
	PIPERXDATAL6,
	PIPERXDATAL7,
	PIPERXELECIDLEL0,
	PIPERXELECIDLEL1,
	PIPERXELECIDLEL2,
	PIPERXELECIDLEL3,
	PIPERXELECIDLEL4,
	PIPERXELECIDLEL5,
	PIPERXELECIDLEL6,
	PIPERXELECIDLEL7,
	PIPERXSTATUSL0,
	PIPERXSTATUSL1,
	PIPERXSTATUSL2,
	PIPERXSTATUSL3,
	PIPERXSTATUSL4,
	PIPERXSTATUSL5,
	PIPERXSTATUSL6,
	PIPERXSTATUSL7,
	PIPERXVALIDL0,
	PIPERXVALIDL1,
	PIPERXVALIDL2,
	PIPERXVALIDL3,
	PIPERXVALIDL4,
	PIPERXVALIDL5,
	PIPERXVALIDL6,
	PIPERXVALIDL7

);

parameter BAR0EXIST = "TRUE";
parameter BAR0PREFETCHABLE = "TRUE";
parameter BAR1EXIST = "FALSE";
parameter BAR1PREFETCHABLE = "FALSE";
parameter BAR2EXIST = "FALSE";
parameter BAR2PREFETCHABLE = "FALSE";
parameter BAR3EXIST = "FALSE";
parameter BAR3PREFETCHABLE = "FALSE";
parameter BAR4EXIST = "FALSE";
parameter BAR4PREFETCHABLE = "FALSE";
parameter BAR5EXIST = "FALSE";
parameter BAR5PREFETCHABLE = "FALSE";
parameter CLKDIVIDED = "FALSE";
parameter INFINITECOMPLETIONS = "TRUE";
parameter LINKSTATUSSLOTCLOCKCONFIG = "FALSE";
parameter PBCAPABILITYSYSTEMALLOCATED = "FALSE";
parameter PMCAPABILITYD1SUPPORT = "FALSE";
parameter PMCAPABILITYD2SUPPORT = "FALSE";
parameter PMCAPABILITYDSI = "TRUE";
parameter RESETMODE = "FALSE";
parameter [10:0] VC0TOTALCREDITSCD = 11'h0;
parameter [10:0] VC0TOTALCREDITSPD = 11'h34;
parameter [10:0] VC1TOTALCREDITSCD = 11'h0;
parameter [10:0] VC1TOTALCREDITSPD = 11'h0;
parameter [11:0] AERBASEPTR = 12'h110;
parameter [11:0] AERCAPABILITYNEXTPTR = 12'h138;
parameter [11:0] DSNBASEPTR = 12'h148;
parameter [11:0] DSNCAPABILITYNEXTPTR = 12'h154;
parameter [11:0] MSIBASEPTR = 12'h48;
parameter [11:0] PBBASEPTR = 12'h138;
parameter [11:0] PBCAPABILITYNEXTPTR = 12'h148;
parameter [11:0] PMBASEPTR = 12'h40;
parameter [11:0] RETRYRAMSIZE = 12'h9;
parameter [11:0] VCBASEPTR = 12'h154;
parameter [11:0] VCCAPABILITYNEXTPTR = 12'h0;
parameter [12:0] VC0RXFIFOBASEC = 13'h98;
parameter [12:0] VC0RXFIFOBASENP = 13'h80;
parameter [12:0] VC0RXFIFOBASEP = 13'h0;
parameter [12:0] VC0RXFIFOLIMITC = 13'h117;
parameter [12:0] VC0RXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0RXFIFOLIMITP = 13'h7f;
parameter [12:0] VC0TXFIFOBASEC = 13'h98;
parameter [12:0] VC0TXFIFOBASENP = 13'h80;
parameter [12:0] VC0TXFIFOBASEP = 13'h0;
parameter [12:0] VC0TXFIFOLIMITC = 13'h117;
parameter [12:0] VC0TXFIFOLIMITNP = 13'h97;
parameter [12:0] VC0TXFIFOLIMITP = 13'h7f;
parameter [12:0] VC1RXFIFOBASEC = 13'h118;
parameter [12:0] VC1RXFIFOBASENP = 13'h118;
parameter [12:0] VC1RXFIFOBASEP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITC = 13'h118;
parameter [12:0] VC1RXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1RXFIFOLIMITP = 13'h118;
parameter [12:0] VC1TXFIFOBASEC = 13'h118;
parameter [12:0] VC1TXFIFOBASENP = 13'h118;
parameter [12:0] VC1TXFIFOBASEP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITC = 13'h118;
parameter [12:0] VC1TXFIFOLIMITNP = 13'h118;
parameter [12:0] VC1TXFIFOLIMITP = 13'h118;
parameter [15:0] DEVICEID = 16'h5050;
parameter [15:0] SUBSYSTEMID = 16'h5050;
parameter [15:0] SUBSYSTEMVENDORID = 16'h10EE;
parameter [15:0] VENDORID = 16'h10EE;
parameter [1:0] LINKCAPABILITYASPMSUPPORT = 2'h1;
parameter [1:0] PBCAPABILITYDW0DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW0PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW1DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW1PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW2DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW2PMSTATE = 2'h0;
parameter [1:0] PBCAPABILITYDW3DATASCALE = 2'h0;
parameter [1:0] PBCAPABILITYDW3PMSTATE = 2'h0;
parameter [23:0] CLASSCODE = 24'h058000;
parameter [2:0] DEVICECAPABILITYENDPOINTL0SLATENCY = 3'h0;
parameter [2:0] DEVICECAPABILITYENDPOINTL1LATENCY = 3'h0;
parameter [2:0] MSICAPABILITYMULTIMSGCAP = 3'h0;
parameter [2:0] PBCAPABILITYDW0PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW0POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW0TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW1PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW1POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW1TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW2PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW2POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW2TYPE = 3'h0;
parameter [2:0] PBCAPABILITYDW3PMSUBSTATE = 3'h0;
parameter [2:0] PBCAPABILITYDW3POWERRAIL = 3'h0;
parameter [2:0] PBCAPABILITYDW3TYPE = 3'h0;
parameter [2:0] PMCAPABILITYAUXCURRENT = 3'h0;
parameter [2:0] PORTVCCAPABILITYEXTENDEDVCCOUNT = 3'h0;
parameter [31:0] CARDBUSCISPOINTER = 32'h0;
parameter [3:0] XPDEVICEPORTTYPE = 4'h0;
parameter [4:0] PMCAPABILITYPMESUPPORT = 5'h0;
parameter [5:0] BAR0MASKWIDTH = 6'h14;
parameter [5:0] BAR1MASKWIDTH = 6'h0;
parameter [5:0] BAR2MASKWIDTH = 6'h0;
parameter [5:0] BAR3MASKWIDTH = 6'h0;
parameter [5:0] BAR4MASKWIDTH = 6'h0;
parameter [5:0] BAR5MASKWIDTH = 6'h0;
parameter [5:0] LINKCAPABILITYMAXLINKWIDTH = 6'h01;
parameter [63:0] DEVICESERIALNUMBER = 64'hE000000001000A35;
parameter [6:0] VC0TOTALCREDITSCH = 7'h0;
parameter [6:0] VC0TOTALCREDITSNPH = 7'h08;
parameter [6:0] VC0TOTALCREDITSPH = 7'h08;
parameter [6:0] VC1TOTALCREDITSCH = 7'h0;
parameter [6:0] VC1TOTALCREDITSNPH = 7'h0;
parameter [6:0] VC1TOTALCREDITSPH = 7'h0;
parameter [7:0] ACTIVELANESIN = 8'h1;
parameter [7:0] CAPABILITIESPOINTER = 8'h40;
parameter [7:0] INTERRUPTPIN = 8'h0;
parameter [7:0] MSICAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PBCAPABILITYDW0BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW1BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW2BASEPOWER = 8'h0;
parameter [7:0] PBCAPABILITYDW3BASEPOWER = 8'h0;
parameter [7:0] PCIECAPABILITYNEXTPTR = 8'h0;
parameter [7:0] PMCAPABILITYNEXTPTR = 8'h60;
parameter [7:0] PMDATA0 = 8'h0;
parameter [7:0] PMDATA1 = 8'h0;
parameter [7:0] PMDATA2 = 8'h0;
parameter [7:0] PMDATA3 = 8'h0;
parameter [7:0] PMDATA4 = 8'h0;
parameter [7:0] PMDATA5 = 8'h0;
parameter [7:0] PMDATA6 = 8'h0;
parameter [7:0] PMDATA7 = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBCAP = 8'h0;
parameter [7:0] PORTVCCAPABILITYVCARBTABLEOFFSET = 8'h0;
parameter [7:0] REVISIONID = 8'h0;
parameter [7:0] XPBASEPTR = 8'h60;
parameter integer BAR0ADDRWIDTH = 0;
parameter integer BAR0IOMEMN = 0;
parameter integer BAR1ADDRWIDTH = 0;
parameter integer BAR1IOMEMN = 0;
parameter integer BAR2ADDRWIDTH = 0;
parameter integer BAR2IOMEMN = 0;
parameter integer BAR3ADDRWIDTH = 0;
parameter integer BAR3IOMEMN = 0;
parameter integer BAR4ADDRWIDTH = 0;
parameter integer BAR4IOMEMN = 0;
parameter integer BAR5IOMEMN = 0;
parameter integer L0SEXITLATENCY = 7;
parameter integer L0SEXITLATENCYCOMCLK = 7;
parameter integer L1EXITLATENCY = 7;
parameter integer L1EXITLATENCYCOMCLK = 7;
parameter integer LOWPRIORITYVCCOUNT = 0;
parameter integer PMDATASCALE0 = 0;
parameter integer PMDATASCALE1 = 0;
parameter integer PMDATASCALE2 = 0;
parameter integer PMDATASCALE3 = 0;
parameter integer PMDATASCALE4 = 0;
parameter integer PMDATASCALE5 = 0;
parameter integer PMDATASCALE6 = 0;
parameter integer PMDATASCALE7 = 0;
parameter integer RETRYRAMREADLATENCY = 3;
parameter integer RETRYRAMWRITELATENCY = 1;
parameter integer TLRAMREADLATENCY = 3;
parameter integer TLRAMWRITELATENCY = 1;
parameter integer TXTSNFTS = 255;
parameter integer TXTSNFTSCOMCLK = 255;
parameter integer XPMAXPAYLOAD = 0;

output BUSMASTERENABLE;
output CRMDOHOTRESETN;
output CRMPWRSOFTRESETN;
output DLLTXPMDLLPOUTSTANDING;
output INTERRUPTDISABLE;
output IOSPACEENABLE;
output L0CFGLOOPBACKACK;
output L0DLLRXACKOUTSTANDING;
output L0DLLTXNONFCOUTSTANDING;
output L0DLLTXOUTSTANDING;
output L0FIRSTCFGWRITEOCCURRED;
output L0MACENTEREDL0;
output L0MACLINKTRAINING;
output L0MACLINKUP;
output L0MACNEWSTATEACK;
output L0MACRXL0SSTATE;
output L0MSIENABLE0;
output L0PMEACK;
output L0PMEEN;
output L0PMEREQOUT;
output L0PWRL1STATE;
output L0PWRL23READYSTATE;
output L0PWRTURNOFFREQ;
output L0PWRTXL0SSTATE;
output L0RXDLLPM;
output L0STATSCFGOTHERRECEIVED;
output L0STATSCFGOTHERTRANSMITTED;
output L0STATSCFGRECEIVED;
output L0STATSCFGTRANSMITTED;
output L0STATSDLLPRECEIVED;
output L0STATSDLLPTRANSMITTED;
output L0STATSOSRECEIVED;
output L0STATSOSTRANSMITTED;
output L0STATSTLPRECEIVED;
output L0STATSTLPTRANSMITTED;
output L0UNLOCKRECEIVED;
output LLKRXEOFN;
output LLKRXEOPN;
output LLKRXSOFN;
output LLKRXSOPN;
output LLKRXSRCLASTREQN;
output LLKRXSRCRDYN;
output LLKTXCONFIGREADYN;
output LLKTXDSTRDYN;
output MEMSPACEENABLE;
output MIMDLLBREN;
output MIMDLLBWEN;
output MIMRXBREN;
output MIMRXBWEN;
output MIMTXBREN;
output MIMTXBWEN;
output PARITYERRORRESPONSE;
output PIPEDESKEWLANESL0;
output PIPEDESKEWLANESL1;
output PIPEDESKEWLANESL2;
output PIPEDESKEWLANESL3;
output PIPEDESKEWLANESL4;
output PIPEDESKEWLANESL5;
output PIPEDESKEWLANESL6;
output PIPEDESKEWLANESL7;
output PIPERESETL0;
output PIPERESETL1;
output PIPERESETL2;
output PIPERESETL3;
output PIPERESETL4;
output PIPERESETL5;
output PIPERESETL6;
output PIPERESETL7;
output PIPERXPOLARITYL0;
output PIPERXPOLARITYL1;
output PIPERXPOLARITYL2;
output PIPERXPOLARITYL3;
output PIPERXPOLARITYL4;
output PIPERXPOLARITYL5;
output PIPERXPOLARITYL6;
output PIPERXPOLARITYL7;
output PIPETXCOMPLIANCEL0;
output PIPETXCOMPLIANCEL1;
output PIPETXCOMPLIANCEL2;
output PIPETXCOMPLIANCEL3;
output PIPETXCOMPLIANCEL4;
output PIPETXCOMPLIANCEL5;
output PIPETXCOMPLIANCEL6;
output PIPETXCOMPLIANCEL7;
output PIPETXDATAKL0;
output PIPETXDATAKL1;
output PIPETXDATAKL2;
output PIPETXDATAKL3;
output PIPETXDATAKL4;
output PIPETXDATAKL5;
output PIPETXDATAKL6;
output PIPETXDATAKL7;
output PIPETXDETECTRXLOOPBACKL0;
output PIPETXDETECTRXLOOPBACKL1;
output PIPETXDETECTRXLOOPBACKL2;
output PIPETXDETECTRXLOOPBACKL3;
output PIPETXDETECTRXLOOPBACKL4;
output PIPETXDETECTRXLOOPBACKL5;
output PIPETXDETECTRXLOOPBACKL6;
output PIPETXDETECTRXLOOPBACKL7;
output PIPETXELECIDLEL0;
output PIPETXELECIDLEL1;
output PIPETXELECIDLEL2;
output PIPETXELECIDLEL3;
output PIPETXELECIDLEL4;
output PIPETXELECIDLEL5;
output PIPETXELECIDLEL6;
output PIPETXELECIDLEL7;
output SERRENABLE;
output URREPORTINGENABLE;
output [11:0] MGMTSTATSCREDIT;
output [11:0] MIMDLLBRADD;
output [11:0] MIMDLLBWADD;
output [12:0] L0COMPLETERID;
output [12:0] MIMRXBRADD;
output [12:0] MIMRXBWADD;
output [12:0] MIMTXBRADD;
output [12:0] MIMTXBWADD;
output [15:0] LLKRXPREFERREDTYPE;
output [16:0] MGMTPSO;
output [1:0] L0PWRSTATE0;
output [1:0] L0RXMACLINKERROR;
output [1:0] LLKRXVALIDN;
output [1:0] PIPEPOWERDOWNL0;
output [1:0] PIPEPOWERDOWNL1;
output [1:0] PIPEPOWERDOWNL2;
output [1:0] PIPEPOWERDOWNL3;
output [1:0] PIPEPOWERDOWNL4;
output [1:0] PIPEPOWERDOWNL5;
output [1:0] PIPEPOWERDOWNL6;
output [1:0] PIPEPOWERDOWNL7;
output [2:0] L0MULTIMSGEN0;
output [2:0] L0RXDLLPMTYPE;
output [2:0] MAXPAYLOADSIZE;
output [2:0] MAXREADREQUESTSIZE;
output [31:0] MGMTRDATA;
output [3:0] L0LTSSMSTATE;
output [3:0] L0MACNEGOTIATEDLINKWIDTH;
output [63:0] LLKRXDATA;
output [63:0] MIMDLLBWDATA;
output [63:0] MIMRXBWDATA;
output [63:0] MIMTXBWDATA;
output [6:0] L0DLLERRORVECTOR;
output [7:0] L0DLLVCSTATUS;
output [7:0] L0DLUPDOWN;
output [7:0] LLKRXCHCOMPLETIONAVAILABLEN;
output [7:0] LLKRXCHNONPOSTEDAVAILABLEN;
output [7:0] LLKRXCHPOSTEDAVAILABLEN;
output [7:0] LLKTCSTATUS;
output [7:0] LLKTXCHCOMPLETIONREADYN;
output [7:0] LLKTXCHNONPOSTEDREADYN;
output [7:0] LLKTXCHPOSTEDREADYN;
output [7:0] PIPETXDATAL0;
output [7:0] PIPETXDATAL1;
output [7:0] PIPETXDATAL2;
output [7:0] PIPETXDATAL3;
output [7:0] PIPETXDATAL4;
output [7:0] PIPETXDATAL5;
output [7:0] PIPETXDATAL6;
output [7:0] PIPETXDATAL7;
output [9:0] LLKTXCHANSPACE;

input AUXPOWER;
input COMPLIANCEAVOID;
input CRMCORECLK;
input CRMCORECLKDLO;
input CRMCORECLKRXO;
input CRMCORECLKTXO;
input CRMLINKRSTN;
input CRMMACRSTN;
input CRMMGMTRSTN;
input CRMNVRSTN;
input CRMURSTN;
input CRMUSERCFGRSTN;
input CRMUSERCLK;
input CRMUSERCLKRXO;
input CRMUSERCLKTXO;
input L0CFGDISABLESCRAMBLE;
input L0CFGLOOPBACKMASTER;
input L0LEGACYINTFUNCT0;
input L0PMEREQIN;
input L0SETCOMPLETERABORTERROR;
input L0SETCOMPLETIONTIMEOUTCORRERROR;
input L0SETCOMPLETIONTIMEOUTUNCORRERROR;
input L0SETDETECTEDCORRERROR;
input L0SETDETECTEDFATALERROR;
input L0SETDETECTEDNONFATALERROR;
input L0SETUNEXPECTEDCOMPLETIONCORRERROR;
input L0SETUNEXPECTEDCOMPLETIONUNCORRERROR;
input L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR;
input L0SETUNSUPPORTEDREQUESTOTHERERROR;
input L0SETUSERDETECTEDPARITYERROR;
input L0SETUSERMASTERDATAPARITY;
input L0SETUSERRECEIVEDMASTERABORT;
input L0SETUSERRECEIVEDTARGETABORT;
input L0SETUSERSIGNALLEDTARGETABORT;
input L0SETUSERSYSTEMERROR;
input L0TRANSACTIONSPENDING;
input LLKRXDSTCONTREQN;
input LLKRXDSTREQN;
input LLKTXEOFN;
input LLKTXEOPN;
input LLKTXSOFN;
input LLKTXSOPN;
input LLKTXSRCDSCN;
input LLKTXSRCRDYN;
input MGMTRDEN;
input MGMTWREN;
input PIPEPHYSTATUSL0;
input PIPEPHYSTATUSL1;
input PIPEPHYSTATUSL2;
input PIPEPHYSTATUSL3;
input PIPEPHYSTATUSL4;
input PIPEPHYSTATUSL5;
input PIPEPHYSTATUSL6;
input PIPEPHYSTATUSL7;
input PIPERXCHANISALIGNEDL0;
input PIPERXCHANISALIGNEDL1;
input PIPERXCHANISALIGNEDL2;
input PIPERXCHANISALIGNEDL3;
input PIPERXCHANISALIGNEDL4;
input PIPERXCHANISALIGNEDL5;
input PIPERXCHANISALIGNEDL6;
input PIPERXCHANISALIGNEDL7;
input PIPERXDATAKL0;
input PIPERXDATAKL1;
input PIPERXDATAKL2;
input PIPERXDATAKL3;
input PIPERXDATAKL4;
input PIPERXDATAKL5;
input PIPERXDATAKL6;
input PIPERXDATAKL7;
input PIPERXELECIDLEL0;
input PIPERXELECIDLEL1;
input PIPERXELECIDLEL2;
input PIPERXELECIDLEL3;
input PIPERXELECIDLEL4;
input PIPERXELECIDLEL5;
input PIPERXELECIDLEL6;
input PIPERXELECIDLEL7;
input PIPERXVALIDL0;
input PIPERXVALIDL1;
input PIPERXVALIDL2;
input PIPERXVALIDL3;
input PIPERXVALIDL4;
input PIPERXVALIDL5;
input PIPERXVALIDL6;
input PIPERXVALIDL7;
input [10:0] MGMTADDR;
input [127:0] L0PACKETHEADERFROMUSER;
input [1:0] LLKRXCHFIFO;
input [1:0] LLKTXCHFIFO;
input [1:0] LLKTXENABLEN;
input [2:0] LLKRXCHTC;
input [2:0] LLKTXCHTC;
input [2:0] PIPERXSTATUSL0;
input [2:0] PIPERXSTATUSL1;
input [2:0] PIPERXSTATUSL2;
input [2:0] PIPERXSTATUSL3;
input [2:0] PIPERXSTATUSL4;
input [2:0] PIPERXSTATUSL5;
input [2:0] PIPERXSTATUSL6;
input [2:0] PIPERXSTATUSL7;
input [31:0] MGMTWDATA;
input [3:0] L0MSIREQUEST0;
input [3:0] MGMTBWREN;
input [63:0] LLKTXDATA;
input [63:0] MIMDLLBRDATA;
input [63:0] MIMRXBRDATA;
input [63:0] MIMTXBRDATA;
input [6:0] MGMTSTATSCREDITSEL;
input [7:0] PIPERXDATAL0;
input [7:0] PIPERXDATAL1;
input [7:0] PIPERXDATAL2;
input [7:0] PIPERXDATAL3;
input [7:0] PIPERXDATAL4;
input [7:0] PIPERXDATAL5;
input [7:0] PIPERXDATAL6;
input [7:0] PIPERXDATAL7;

wire OPEN_CRMRXHOTRESETN;
wire OPEN_L0ASAUTONOMOUSINITCOMPLETED;
wire OPEN_L0CORRERRMSGRCVD;
wire OPEN_L0DLLASTXSTATE;
wire OPEN_L0FATALERRMSGRCVD;
wire OPEN_L0FWDCORRERROUT;
wire OPEN_L0FWDFATALERROUT;
wire OPEN_L0FWDNONFATALERROUT;
wire OPEN_L0MACUPSTREAMDOWNSTREAM;
wire OPEN_L0NONFATALERRMSGRCVD;
wire OPEN_L0POWERCONTROLLERCONTROL;
wire OPEN_L0PWRINHIBITTRANSFERS;
wire OPEN_L0PWRL23READYDEVICE;
wire OPEN_L0RECEIVEDASSERTINTALEGACYINT;
wire OPEN_L0RECEIVEDASSERTINTBLEGACYINT;
wire OPEN_L0RECEIVEDASSERTINTCLEGACYINT;
wire OPEN_L0RECEIVEDASSERTINTDLEGACYINT;
wire OPEN_L0RECEIVEDDEASSERTINTALEGACYINT;
wire OPEN_L0RECEIVEDDEASSERTINTBLEGACYINT;
wire OPEN_L0RECEIVEDDEASSERTINTCLEGACYINT;
wire OPEN_L0RECEIVEDDEASSERTINTDLEGACYINT;
wire OPEN_L0RXBEACON;
wire OPEN_L0RXDLLSBFCUPDATE;
wire OPEN_L0RXDLLTLPECRCOK;
wire OPEN_L0TOGGLEELECTROMECHANICALINTERLOCK;
wire OPEN_L0TXDLLPMUPDATED;
wire OPEN_L0TXDLLSBFCUPDATED;
wire OPEN_LLKRX4DWHEADERN;
wire OPEN_LLKRXCHCONFIGAVAILABLEN;
wire OPEN_LLKRXCHCONFIGPARTIALN;
wire OPEN_LLKRXECRCBADN;
wire OPEN_LLKRXSRCDSCN;
wire [15:0] OPEN_L0ERRMSGREQID;
wire [18:0] OPEN_L0RXDLLSBFCDATA;
wire [19:0] OPEN_L0RXDLLFCNPOSTBYPCRED;
wire [1:0] OPEN_L0ATTENTIONINDICATORCONTROL;
wire [1:0] OPEN_L0DLLASRXSTATE;
wire [1:0] OPEN_L0POWERINDICATORCONTROL;
wire [1:0] OPEN_L0RXDLLTLPEND;
wire [23:0] OPEN_L0RXDLLFCCMPLMCCRED;
wire [23:0] OPEN_L0RXDLLFCPOSTORDCRED;
wire [2:0] OPEN_L0MCFOUND;
wire [2:0] OPEN_L0TRANSFORMEDVC;
wire [3:0] OPEN_L0UCBYPFOUND;
wire [3:0] OPEN_L0UCORDFOUND;
wire [7:0] OPEN_L0RXDLLFCCMPLMCUPDATE;
wire [7:0] OPEN_L0RXDLLFCNPOSTBYPUPDATE;
wire [7:0] OPEN_L0RXDLLFCPOSTORDUPDATE;
wire [7:0] OPEN_L0TXDLLFCCMPLMCUPDATED;
wire [7:0] OPEN_L0TXDLLFCNPOSTBYPUPDATED;
wire [7:0] OPEN_L0TXDLLFCPOSTORDUPDATED;
wire [7:0] OPEN_LLKRXCHCOMPLETIONPARTIALN;
wire [7:0] OPEN_LLKRXCHNONPOSTEDPARTIALN;
wire [7:0] OPEN_LLKRXCHPOSTEDPARTIALN;

PCIE_INTERNAL_1_1 pcie_internal_1_1_1 (
	.AUXPOWER (AUXPOWER),
	.BUSMASTERENABLE (BUSMASTERENABLE),
	.CFGNEGOTIATEDLINKWIDTH (6'b0),
	.COMPLIANCEAVOID (COMPLIANCEAVOID),
	.CRMCFGBRIDGEHOTRESET (1'b0),
	.CRMCORECLK (CRMCORECLK),
	.CRMCORECLKDLO (CRMCORECLKDLO),
	.CRMCORECLKRXO (CRMCORECLKRXO),
	.CRMCORECLKTXO (CRMCORECLKTXO),
	.CRMDOHOTRESETN (CRMDOHOTRESETN),
	.CRMLINKRSTN (CRMLINKRSTN),
	.CRMMACRSTN (CRMMACRSTN),
	.CRMMGMTRSTN (CRMMGMTRSTN),
	.CRMNVRSTN (CRMNVRSTN),
	.CRMPWRSOFTRESETN (CRMPWRSOFTRESETN),
	.CRMRXHOTRESETN (OPEN_CRMRXHOTRESETN),
	.CRMTXHOTRESETN (1'b1),
	.CRMURSTN (CRMURSTN),
	.CRMUSERCFGRSTN (CRMUSERCFGRSTN),
	.CRMUSERCLK (CRMUSERCLK),
	.CRMUSERCLKRXO (CRMUSERCLKRXO),
	.CRMUSERCLKTXO (CRMUSERCLKTXO),
	.CROSSLINKSEED (1'b1),
	.DLLTXPMDLLPOUTSTANDING (DLLTXPMDLLPOUTSTANDING),
	.INTERRUPTDISABLE (INTERRUPTDISABLE),
	.IOSPACEENABLE (IOSPACEENABLE),
	.L0ACKNAKTIMERADJUSTMENT (12'b0),
	.L0ALLDOWNPORTSINL1 (1'b0),
	.L0ALLDOWNRXPORTSINL0S (1'b0),
	.L0ASAUTONOMOUSINITCOMPLETED (OPEN_L0ASAUTONOMOUSINITCOMPLETED),
	.L0ASE (1'b0),
	.L0ASPORTCOUNT (8'b0),
	.L0ASTURNPOOLBITSCONSUMED (3'b0),
	.L0ATTENTIONBUTTONPRESSED (1'b0),
	.L0ATTENTIONINDICATORCONTROL (OPEN_L0ATTENTIONINDICATORCONTROL),
	.L0CFGASSPANTREEOWNEDSTATE (1'b0),
	.L0CFGASSTATECHANGECMD (4'b0),
	.L0CFGDISABLESCRAMBLE (L0CFGDISABLESCRAMBLE),
	.L0CFGEXTENDEDSYNC (1'b0),
	.L0CFGL0SENTRYENABLE (1'b0),
	.L0CFGL0SENTRYSUP (1'b0),
	.L0CFGL0SEXITLAT (3'b0),
	.L0CFGLINKDISABLE (1'b0),
	.L0CFGLOOPBACKACK (L0CFGLOOPBACKACK),
	.L0CFGLOOPBACKMASTER (L0CFGLOOPBACKMASTER),
	.L0CFGNEGOTIATEDMAXP (3'b0),
	.L0CFGVCENABLE (8'b0),
	.L0CFGVCID (24'b0),
	.L0COMPLETERID (L0COMPLETERID),
	.L0CORRERRMSGRCVD (OPEN_L0CORRERRMSGRCVD),
	.L0DLLASRXSTATE (OPEN_L0DLLASRXSTATE),
	.L0DLLASTXSTATE (OPEN_L0DLLASTXSTATE),
	.L0DLLERRORVECTOR (L0DLLERRORVECTOR),
	.L0DLLHOLDLINKUP (1'b0),
	.L0DLLRXACKOUTSTANDING (L0DLLRXACKOUTSTANDING),
	.L0DLLTXNONFCOUTSTANDING (L0DLLTXNONFCOUTSTANDING),
	.L0DLLTXOUTSTANDING (L0DLLTXOUTSTANDING),
	.L0DLLVCSTATUS (L0DLLVCSTATUS),
	.L0DLUPDOWN (L0DLUPDOWN),
	.L0ELECTROMECHANICALINTERLOCKENGAGED (1'b0),
	.L0ERRMSGREQID (OPEN_L0ERRMSGREQID),
	.L0FATALERRMSGRCVD (OPEN_L0FATALERRMSGRCVD),
	.L0FIRSTCFGWRITEOCCURRED (L0FIRSTCFGWRITEOCCURRED),
	.L0FWDASSERTINTALEGACYINT (1'b0),
	.L0FWDASSERTINTBLEGACYINT (1'b0),
	.L0FWDASSERTINTCLEGACYINT (1'b0),
	.L0FWDASSERTINTDLEGACYINT (1'b0),
	.L0FWDCORRERRIN (1'b0),
	.L0FWDCORRERROUT (OPEN_L0FWDCORRERROUT),
	.L0FWDDEASSERTINTALEGACYINT (1'b0),
	.L0FWDDEASSERTINTBLEGACYINT (1'b0),
	.L0FWDDEASSERTINTCLEGACYINT (1'b0),
	.L0FWDDEASSERTINTDLEGACYINT (1'b0),
	.L0FWDFATALERRIN (1'b0),
	.L0FWDFATALERROUT (OPEN_L0FWDFATALERROUT),
	.L0FWDNONFATALERRIN (1'b0),
	.L0FWDNONFATALERROUT (OPEN_L0FWDNONFATALERROUT),
	.L0LEGACYINTFUNCT0 (L0LEGACYINTFUNCT0),
	.L0LTSSMSTATE (L0LTSSMSTATE),
	.L0MACENTEREDL0 (L0MACENTEREDL0),
	.L0MACLINKTRAINING (L0MACLINKTRAINING),
	.L0MACLINKUP (L0MACLINKUP),
	.L0MACNEGOTIATEDLINKWIDTH (L0MACNEGOTIATEDLINKWIDTH),
	.L0MACNEWSTATEACK (L0MACNEWSTATEACK),
	.L0MACRXL0SSTATE (L0MACRXL0SSTATE),
	.L0MACUPSTREAMDOWNSTREAM (OPEN_L0MACUPSTREAMDOWNSTREAM),
	.L0MCFOUND (OPEN_L0MCFOUND),
	.L0MRLSENSORCLOSEDN (1'b0),
	.L0MSIENABLE0 (L0MSIENABLE0),
	.L0MSIREQUEST0 (L0MSIREQUEST0),
	.L0MULTIMSGEN0 (L0MULTIMSGEN0),
	.L0NONFATALERRMSGRCVD (OPEN_L0NONFATALERRMSGRCVD),
	.L0PACKETHEADERFROMUSER (L0PACKETHEADERFROMUSER),
	.L0PMEACK (L0PMEACK),
	.L0PMEEN (L0PMEEN),
	.L0PMEREQIN (L0PMEREQIN),
	.L0PMEREQOUT (L0PMEREQOUT),
	.L0PORTNUMBER (8'b0),
	.L0POWERCONTROLLERCONTROL (OPEN_L0POWERCONTROLLERCONTROL),
	.L0POWERFAULTDETECTED (1'b0),
	.L0POWERINDICATORCONTROL (OPEN_L0POWERINDICATORCONTROL),
	.L0PRESENCEDETECTSLOTEMPTYN (1'b0),
	.L0PWRINHIBITTRANSFERS (OPEN_L0PWRINHIBITTRANSFERS),
	.L0PWRL1STATE (L0PWRL1STATE),
	.L0PWRL23READYDEVICE (OPEN_L0PWRL23READYDEVICE),
	.L0PWRL23READYSTATE (L0PWRL23READYSTATE),
	.L0PWRNEWSTATEREQ (1'b0),
	.L0PWRNEXTLINKSTATE (2'b0),
	.L0PWRSTATE0 (L0PWRSTATE0),
	.L0PWRTURNOFFREQ (L0PWRTURNOFFREQ),
	.L0PWRTXL0SSTATE (L0PWRTXL0SSTATE),
	.L0RECEIVEDASSERTINTALEGACYINT (OPEN_L0RECEIVEDASSERTINTALEGACYINT),
	.L0RECEIVEDASSERTINTBLEGACYINT (OPEN_L0RECEIVEDASSERTINTBLEGACYINT),
	.L0RECEIVEDASSERTINTCLEGACYINT (OPEN_L0RECEIVEDASSERTINTCLEGACYINT),
	.L0RECEIVEDASSERTINTDLEGACYINT (OPEN_L0RECEIVEDASSERTINTDLEGACYINT),
	.L0RECEIVEDDEASSERTINTALEGACYINT (OPEN_L0RECEIVEDDEASSERTINTALEGACYINT),
	.L0RECEIVEDDEASSERTINTBLEGACYINT (OPEN_L0RECEIVEDDEASSERTINTBLEGACYINT),
	.L0RECEIVEDDEASSERTINTCLEGACYINT (OPEN_L0RECEIVEDDEASSERTINTCLEGACYINT),
	.L0RECEIVEDDEASSERTINTDLEGACYINT (OPEN_L0RECEIVEDDEASSERTINTDLEGACYINT),
	.L0REPLAYTIMERADJUSTMENT (12'b0),
	.L0ROOTTURNOFFREQ (1'b0),
	.L0RXBEACON (OPEN_L0RXBEACON),
	.L0RXDLLFCCMPLMCCRED (OPEN_L0RXDLLFCCMPLMCCRED),
	.L0RXDLLFCCMPLMCUPDATE (OPEN_L0RXDLLFCCMPLMCUPDATE),
	.L0RXDLLFCNPOSTBYPCRED (OPEN_L0RXDLLFCNPOSTBYPCRED),
	.L0RXDLLFCNPOSTBYPUPDATE (OPEN_L0RXDLLFCNPOSTBYPUPDATE),
	.L0RXDLLFCPOSTORDCRED (OPEN_L0RXDLLFCPOSTORDCRED),
	.L0RXDLLFCPOSTORDUPDATE (OPEN_L0RXDLLFCPOSTORDUPDATE),
	.L0RXDLLPM (L0RXDLLPM),
	.L0RXDLLPMTYPE (L0RXDLLPMTYPE),
	.L0RXDLLSBFCDATA (OPEN_L0RXDLLSBFCDATA),
	.L0RXDLLSBFCUPDATE (OPEN_L0RXDLLSBFCUPDATE),
	.L0RXDLLTLPECRCOK (OPEN_L0RXDLLTLPECRCOK),
	.L0RXDLLTLPEND (OPEN_L0RXDLLTLPEND),
	.L0RXMACLINKERROR (L0RXMACLINKERROR),
	.L0RXTLTLPNONINITIALIZEDVC (8'b0),
	.L0SENDUNLOCKMESSAGE (1'b0),
	.L0SETCOMPLETERABORTERROR (L0SETCOMPLETERABORTERROR),
	.L0SETCOMPLETIONTIMEOUTCORRERROR (L0SETCOMPLETIONTIMEOUTCORRERROR),
	.L0SETCOMPLETIONTIMEOUTUNCORRERROR (L0SETCOMPLETIONTIMEOUTUNCORRERROR),
	.L0SETDETECTEDCORRERROR (L0SETDETECTEDCORRERROR),
	.L0SETDETECTEDFATALERROR (L0SETDETECTEDFATALERROR),
	.L0SETDETECTEDNONFATALERROR (L0SETDETECTEDNONFATALERROR),
	.L0SETLINKDETECTEDPARITYERROR (1'b0),
	.L0SETLINKMASTERDATAPARITY (1'b0),
	.L0SETLINKRECEIVEDMASTERABORT (1'b0),
	.L0SETLINKRECEIVEDTARGETABORT (1'b0),
	.L0SETLINKSIGNALLEDTARGETABORT (1'b0),
	.L0SETLINKSYSTEMERROR (1'b0),
	.L0SETUNEXPECTEDCOMPLETIONCORRERROR (L0SETUNEXPECTEDCOMPLETIONCORRERROR),
	.L0SETUNEXPECTEDCOMPLETIONUNCORRERROR (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR),
	.L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR),
	.L0SETUNSUPPORTEDREQUESTOTHERERROR (L0SETUNSUPPORTEDREQUESTOTHERERROR),
	.L0SETUSERDETECTEDPARITYERROR (L0SETUSERDETECTEDPARITYERROR),
	.L0SETUSERMASTERDATAPARITY (L0SETUSERMASTERDATAPARITY),
	.L0SETUSERRECEIVEDMASTERABORT (L0SETUSERRECEIVEDMASTERABORT),
	.L0SETUSERRECEIVEDTARGETABORT (L0SETUSERRECEIVEDTARGETABORT),
	.L0SETUSERSIGNALLEDTARGETABORT (L0SETUSERSIGNALLEDTARGETABORT),
	.L0SETUSERSYSTEMERROR (L0SETUSERSYSTEMERROR),
	.L0STATSCFGOTHERRECEIVED (L0STATSCFGOTHERRECEIVED),
	.L0STATSCFGOTHERTRANSMITTED (L0STATSCFGOTHERTRANSMITTED),
	.L0STATSCFGRECEIVED (L0STATSCFGRECEIVED),
	.L0STATSCFGTRANSMITTED (L0STATSCFGTRANSMITTED),
	.L0STATSDLLPRECEIVED (L0STATSDLLPRECEIVED),
	.L0STATSDLLPTRANSMITTED (L0STATSDLLPTRANSMITTED),
	.L0STATSOSRECEIVED (L0STATSOSRECEIVED),
	.L0STATSOSTRANSMITTED (L0STATSOSTRANSMITTED),
	.L0STATSTLPRECEIVED (L0STATSTLPRECEIVED),
	.L0STATSTLPTRANSMITTED (L0STATSTLPTRANSMITTED),
	.L0TLASFCCREDSTARVATION (1'b0),
	.L0TLLINKRETRAIN (1'b0),
	.L0TOGGLEELECTROMECHANICALINTERLOCK (OPEN_L0TOGGLEELECTROMECHANICALINTERLOCK),
	.L0TRANSACTIONSPENDING (L0TRANSACTIONSPENDING),
	.L0TRANSFORMEDVC (OPEN_L0TRANSFORMEDVC),
	.L0TXBEACON (1'b0),
	.L0TXCFGPM (1'b0),
	.L0TXCFGPMTYPE (3'b0),
	.L0TXDLLFCCMPLMCUPDATED (OPEN_L0TXDLLFCCMPLMCUPDATED),
	.L0TXDLLFCNPOSTBYPUPDATED (OPEN_L0TXDLLFCNPOSTBYPUPDATED),
	.L0TXDLLFCPOSTORDUPDATED (OPEN_L0TXDLLFCPOSTORDUPDATED),
	.L0TXDLLPMUPDATED (OPEN_L0TXDLLPMUPDATED),
	.L0TXDLLSBFCUPDATED (OPEN_L0TXDLLSBFCUPDATED),
	.L0TXTLFCCMPLMCCRED (160'b0),
	.L0TXTLFCCMPLMCUPDATE (16'b0),
	.L0TXTLFCNPOSTBYPCRED (192'b0),
	.L0TXTLFCNPOSTBYPUPDATE (16'b0),
	.L0TXTLFCPOSTORDCRED (160'b0),
	.L0TXTLFCPOSTORDUPDATE (16'b0),
	.L0TXTLSBFCDATA (19'b0),
	.L0TXTLSBFCUPDATE (1'b0),
	.L0TXTLTLPDATA (64'b0),
	.L0TXTLTLPEDB (1'b0),
	.L0TXTLTLPENABLE (2'b0),
	.L0TXTLTLPEND (2'b0),
	.L0TXTLTLPLATENCY (4'b0),
	.L0TXTLTLPREQ (1'b0),
	.L0TXTLTLPREQEND (1'b0),
	.L0TXTLTLPWIDTH (1'b0),
	.L0UCBYPFOUND (OPEN_L0UCBYPFOUND),
	.L0UCORDFOUND (OPEN_L0UCORDFOUND),
	.L0UNLOCKRECEIVED (L0UNLOCKRECEIVED),
	.L0UPSTREAMRXPORTINL0S (1'b0),
	.L0VC0PREVIEWEXPAND (1'b0),
	.L0WAKEN (1'b1),
	.LLKRX4DWHEADERN (OPEN_LLKRX4DWHEADERN),
	.LLKRXCHCOMPLETIONAVAILABLEN (LLKRXCHCOMPLETIONAVAILABLEN),
	.LLKRXCHCOMPLETIONPARTIALN (OPEN_LLKRXCHCOMPLETIONPARTIALN),
	.LLKRXCHCONFIGAVAILABLEN (OPEN_LLKRXCHCONFIGAVAILABLEN),
	.LLKRXCHCONFIGPARTIALN (OPEN_LLKRXCHCONFIGPARTIALN),
	.LLKRXCHFIFO (LLKRXCHFIFO),
	.LLKRXCHNONPOSTEDAVAILABLEN (LLKRXCHNONPOSTEDAVAILABLEN),
	.LLKRXCHNONPOSTEDPARTIALN (OPEN_LLKRXCHNONPOSTEDPARTIALN),
	.LLKRXCHPOSTEDAVAILABLEN (LLKRXCHPOSTEDAVAILABLEN),
	.LLKRXCHPOSTEDPARTIALN (OPEN_LLKRXCHPOSTEDPARTIALN),
	.LLKRXCHTC (LLKRXCHTC),
	.LLKRXDATA (LLKRXDATA),
	.LLKRXDSTCONTREQN (LLKRXDSTCONTREQN),
	.LLKRXDSTREQN (LLKRXDSTREQN),
	.LLKRXECRCBADN (OPEN_LLKRXECRCBADN),
	.LLKRXEOFN (LLKRXEOFN),
	.LLKRXEOPN (LLKRXEOPN),
	.LLKRXPREFERREDTYPE (LLKRXPREFERREDTYPE),
	.LLKRXSOFN (LLKRXSOFN),
	.LLKRXSOPN (LLKRXSOPN),
	.LLKRXSRCDSCN (OPEN_LLKRXSRCDSCN),
	.LLKRXSRCLASTREQN (LLKRXSRCLASTREQN),
	.LLKRXSRCRDYN (LLKRXSRCRDYN),
	.LLKRXVALIDN (LLKRXVALIDN),
	.LLKTCSTATUS (LLKTCSTATUS),
	.LLKTX4DWHEADERN (1'b1),
	.LLKTXCHANSPACE (LLKTXCHANSPACE),
	.LLKTXCHCOMPLETIONREADYN (LLKTXCHCOMPLETIONREADYN),
	.LLKTXCHFIFO (LLKTXCHFIFO),
	.LLKTXCHNONPOSTEDREADYN (LLKTXCHNONPOSTEDREADYN),
	.LLKTXCHPOSTEDREADYN (LLKTXCHPOSTEDREADYN),
	.LLKTXCHTC (LLKTXCHTC),
	.LLKTXCOMPLETEN (1'b1),
	.LLKTXCONFIGREADYN (LLKTXCONFIGREADYN),
	.LLKTXCREATEECRCN (1'b1),
	.LLKTXDATA (LLKTXDATA),
	.LLKTXDSTRDYN (LLKTXDSTRDYN),
	.LLKTXENABLEN (LLKTXENABLEN),
	.LLKTXEOFN (LLKTXEOFN),
	.LLKTXEOPN (LLKTXEOPN),
	.LLKTXSOFN (LLKTXSOFN),
	.LLKTXSOPN (LLKTXSOPN),
	.LLKTXSRCDSCN (LLKTXSRCDSCN),
	.LLKTXSRCRDYN (LLKTXSRCRDYN),
	.MAINPOWER (1'b1),
	.MAXPAYLOADSIZE (MAXPAYLOADSIZE),
	.MAXREADREQUESTSIZE (MAXREADREQUESTSIZE),
	.MEMSPACEENABLE (MEMSPACEENABLE),
	.MGMTADDR (MGMTADDR),
	.MGMTBWREN (MGMTBWREN),
	.MGMTPSO (MGMTPSO),
	.MGMTRDATA (MGMTRDATA),
	.MGMTRDEN (MGMTRDEN),
	.MGMTSTATSCREDIT (MGMTSTATSCREDIT),
	.MGMTSTATSCREDITSEL (MGMTSTATSCREDITSEL),
	.MGMTWDATA (MGMTWDATA),
	.MGMTWREN (MGMTWREN),
	.MIMDLLBRADD (MIMDLLBRADD),
	.MIMDLLBRDATA (MIMDLLBRDATA),
	.MIMDLLBREN (MIMDLLBREN),
	.MIMDLLBWADD (MIMDLLBWADD),
	.MIMDLLBWDATA (MIMDLLBWDATA),
	.MIMDLLBWEN (MIMDLLBWEN),
	.MIMRXBRADD (MIMRXBRADD),
	.MIMRXBRDATA (MIMRXBRDATA),
	.MIMRXBREN (MIMRXBREN),
	.MIMRXBWADD (MIMRXBWADD),
	.MIMRXBWDATA (MIMRXBWDATA),
	.MIMRXBWEN (MIMRXBWEN),
	.MIMTXBRADD (MIMTXBRADD),
	.MIMTXBRDATA (MIMTXBRDATA),
	.MIMTXBREN (MIMTXBREN),
	.MIMTXBWADD (MIMTXBWADD),
	.MIMTXBWDATA (MIMTXBWDATA),
	.MIMTXBWEN (MIMTXBWEN),
	.PARITYERRORRESPONSE (PARITYERRORRESPONSE),
	.PIPEDESKEWLANESL0 (PIPEDESKEWLANESL0),
	.PIPEDESKEWLANESL1 (PIPEDESKEWLANESL1),
	.PIPEDESKEWLANESL2 (PIPEDESKEWLANESL2),
	.PIPEDESKEWLANESL3 (PIPEDESKEWLANESL3),
	.PIPEDESKEWLANESL4 (PIPEDESKEWLANESL4),
	.PIPEDESKEWLANESL5 (PIPEDESKEWLANESL5),
	.PIPEDESKEWLANESL6 (PIPEDESKEWLANESL6),
	.PIPEDESKEWLANESL7 (PIPEDESKEWLANESL7),
	.PIPEPHYSTATUSL0 (PIPEPHYSTATUSL0),
	.PIPEPHYSTATUSL1 (PIPEPHYSTATUSL1),
	.PIPEPHYSTATUSL2 (PIPEPHYSTATUSL2),
	.PIPEPHYSTATUSL3 (PIPEPHYSTATUSL3),
	.PIPEPHYSTATUSL4 (PIPEPHYSTATUSL4),
	.PIPEPHYSTATUSL5 (PIPEPHYSTATUSL5),
	.PIPEPHYSTATUSL6 (PIPEPHYSTATUSL6),
	.PIPEPHYSTATUSL7 (PIPEPHYSTATUSL7),
	.PIPEPOWERDOWNL0 (PIPEPOWERDOWNL0),
	.PIPEPOWERDOWNL1 (PIPEPOWERDOWNL1),
	.PIPEPOWERDOWNL2 (PIPEPOWERDOWNL2),
	.PIPEPOWERDOWNL3 (PIPEPOWERDOWNL3),
	.PIPEPOWERDOWNL4 (PIPEPOWERDOWNL4),
	.PIPEPOWERDOWNL5 (PIPEPOWERDOWNL5),
	.PIPEPOWERDOWNL6 (PIPEPOWERDOWNL6),
	.PIPEPOWERDOWNL7 (PIPEPOWERDOWNL7),
	.PIPERESETL0 (PIPERESETL0),
	.PIPERESETL1 (PIPERESETL1),
	.PIPERESETL2 (PIPERESETL2),
	.PIPERESETL3 (PIPERESETL3),
	.PIPERESETL4 (PIPERESETL4),
	.PIPERESETL5 (PIPERESETL5),
	.PIPERESETL6 (PIPERESETL6),
	.PIPERESETL7 (PIPERESETL7),
	.PIPERXCHANISALIGNEDL0 (PIPERXCHANISALIGNEDL0),
	.PIPERXCHANISALIGNEDL1 (PIPERXCHANISALIGNEDL1),
	.PIPERXCHANISALIGNEDL2 (PIPERXCHANISALIGNEDL2),
	.PIPERXCHANISALIGNEDL3 (PIPERXCHANISALIGNEDL3),
	.PIPERXCHANISALIGNEDL4 (PIPERXCHANISALIGNEDL4),
	.PIPERXCHANISALIGNEDL5 (PIPERXCHANISALIGNEDL5),
	.PIPERXCHANISALIGNEDL6 (PIPERXCHANISALIGNEDL6),
	.PIPERXCHANISALIGNEDL7 (PIPERXCHANISALIGNEDL7),
	.PIPERXDATAKL0 (PIPERXDATAKL0),
	.PIPERXDATAKL1 (PIPERXDATAKL1),
	.PIPERXDATAKL2 (PIPERXDATAKL2),
	.PIPERXDATAKL3 (PIPERXDATAKL3),
	.PIPERXDATAKL4 (PIPERXDATAKL4),
	.PIPERXDATAKL5 (PIPERXDATAKL5),
	.PIPERXDATAKL6 (PIPERXDATAKL6),
	.PIPERXDATAKL7 (PIPERXDATAKL7),
	.PIPERXDATAL0 (PIPERXDATAL0),
	.PIPERXDATAL1 (PIPERXDATAL1),
	.PIPERXDATAL2 (PIPERXDATAL2),
	.PIPERXDATAL3 (PIPERXDATAL3),
	.PIPERXDATAL4 (PIPERXDATAL4),
	.PIPERXDATAL5 (PIPERXDATAL5),
	.PIPERXDATAL6 (PIPERXDATAL6),
	.PIPERXDATAL7 (PIPERXDATAL7),
	.PIPERXELECIDLEL0 (PIPERXELECIDLEL0),
	.PIPERXELECIDLEL1 (PIPERXELECIDLEL1),
	.PIPERXELECIDLEL2 (PIPERXELECIDLEL2),
	.PIPERXELECIDLEL3 (PIPERXELECIDLEL3),
	.PIPERXELECIDLEL4 (PIPERXELECIDLEL4),
	.PIPERXELECIDLEL5 (PIPERXELECIDLEL5),
	.PIPERXELECIDLEL6 (PIPERXELECIDLEL6),
	.PIPERXELECIDLEL7 (PIPERXELECIDLEL7),
	.PIPERXPOLARITYL0 (PIPERXPOLARITYL0),
	.PIPERXPOLARITYL1 (PIPERXPOLARITYL1),
	.PIPERXPOLARITYL2 (PIPERXPOLARITYL2),
	.PIPERXPOLARITYL3 (PIPERXPOLARITYL3),
	.PIPERXPOLARITYL4 (PIPERXPOLARITYL4),
	.PIPERXPOLARITYL5 (PIPERXPOLARITYL5),
	.PIPERXPOLARITYL6 (PIPERXPOLARITYL6),
	.PIPERXPOLARITYL7 (PIPERXPOLARITYL7),
	.PIPERXSTATUSL0 (PIPERXSTATUSL0),
	.PIPERXSTATUSL1 (PIPERXSTATUSL1),
	.PIPERXSTATUSL2 (PIPERXSTATUSL2),
	.PIPERXSTATUSL3 (PIPERXSTATUSL3),
	.PIPERXSTATUSL4 (PIPERXSTATUSL4),
	.PIPERXSTATUSL5 (PIPERXSTATUSL5),
	.PIPERXSTATUSL6 (PIPERXSTATUSL6),
	.PIPERXSTATUSL7 (PIPERXSTATUSL7),
	.PIPERXVALIDL0 (PIPERXVALIDL0),
	.PIPERXVALIDL1 (PIPERXVALIDL1),
	.PIPERXVALIDL2 (PIPERXVALIDL2),
	.PIPERXVALIDL3 (PIPERXVALIDL3),
	.PIPERXVALIDL4 (PIPERXVALIDL4),
	.PIPERXVALIDL5 (PIPERXVALIDL5),
	.PIPERXVALIDL6 (PIPERXVALIDL6),
	.PIPERXVALIDL7 (PIPERXVALIDL7),
	.PIPETXCOMPLIANCEL0 (PIPETXCOMPLIANCEL0),
	.PIPETXCOMPLIANCEL1 (PIPETXCOMPLIANCEL1),
	.PIPETXCOMPLIANCEL2 (PIPETXCOMPLIANCEL2),
	.PIPETXCOMPLIANCEL3 (PIPETXCOMPLIANCEL3),
	.PIPETXCOMPLIANCEL4 (PIPETXCOMPLIANCEL4),
	.PIPETXCOMPLIANCEL5 (PIPETXCOMPLIANCEL5),
	.PIPETXCOMPLIANCEL6 (PIPETXCOMPLIANCEL6),
	.PIPETXCOMPLIANCEL7 (PIPETXCOMPLIANCEL7),
	.PIPETXDATAKL0 (PIPETXDATAKL0),
	.PIPETXDATAKL1 (PIPETXDATAKL1),
	.PIPETXDATAKL2 (PIPETXDATAKL2),
	.PIPETXDATAKL3 (PIPETXDATAKL3),
	.PIPETXDATAKL4 (PIPETXDATAKL4),
	.PIPETXDATAKL5 (PIPETXDATAKL5),
	.PIPETXDATAKL6 (PIPETXDATAKL6),
	.PIPETXDATAKL7 (PIPETXDATAKL7),
	.PIPETXDATAL0 (PIPETXDATAL0),
	.PIPETXDATAL1 (PIPETXDATAL1),
	.PIPETXDATAL2 (PIPETXDATAL2),
	.PIPETXDATAL3 (PIPETXDATAL3),
	.PIPETXDATAL4 (PIPETXDATAL4),
	.PIPETXDATAL5 (PIPETXDATAL5),
	.PIPETXDATAL6 (PIPETXDATAL6),
	.PIPETXDATAL7 (PIPETXDATAL7),
	.PIPETXDETECTRXLOOPBACKL0 (PIPETXDETECTRXLOOPBACKL0),
	.PIPETXDETECTRXLOOPBACKL1 (PIPETXDETECTRXLOOPBACKL1),
	.PIPETXDETECTRXLOOPBACKL2 (PIPETXDETECTRXLOOPBACKL2),
	.PIPETXDETECTRXLOOPBACKL3 (PIPETXDETECTRXLOOPBACKL3),
	.PIPETXDETECTRXLOOPBACKL4 (PIPETXDETECTRXLOOPBACKL4),
	.PIPETXDETECTRXLOOPBACKL5 (PIPETXDETECTRXLOOPBACKL5),
	.PIPETXDETECTRXLOOPBACKL6 (PIPETXDETECTRXLOOPBACKL6),
	.PIPETXDETECTRXLOOPBACKL7 (PIPETXDETECTRXLOOPBACKL7),
	.PIPETXELECIDLEL0 (PIPETXELECIDLEL0),
	.PIPETXELECIDLEL1 (PIPETXELECIDLEL1),
	.PIPETXELECIDLEL2 (PIPETXELECIDLEL2),
	.PIPETXELECIDLEL3 (PIPETXELECIDLEL3),
	.PIPETXELECIDLEL4 (PIPETXELECIDLEL4),
	.PIPETXELECIDLEL5 (PIPETXELECIDLEL5),
	.PIPETXELECIDLEL6 (PIPETXELECIDLEL6),
	.PIPETXELECIDLEL7 (PIPETXELECIDLEL7),
	.SERRENABLE (SERRENABLE),
	.URREPORTINGENABLE (URREPORTINGENABLE)
);

defparam pcie_internal_1_1_1.ACTIVELANESIN = ACTIVELANESIN;
defparam pcie_internal_1_1_1.AERBASEPTR = AERBASEPTR;
defparam pcie_internal_1_1_1.AERCAPABILITYECRCCHECKCAPABLE = "FALSE";
defparam pcie_internal_1_1_1.AERCAPABILITYECRCGENCAPABLE = "FALSE";
defparam pcie_internal_1_1_1.AERCAPABILITYNEXTPTR = AERCAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.BAR0ADDRWIDTH = BAR0ADDRWIDTH;
defparam pcie_internal_1_1_1.BAR0EXIST = BAR0EXIST;
defparam pcie_internal_1_1_1.BAR0IOMEMN = BAR0IOMEMN;
defparam pcie_internal_1_1_1.BAR0MASKWIDTH = BAR0MASKWIDTH;
defparam pcie_internal_1_1_1.BAR0PREFETCHABLE = BAR0PREFETCHABLE;
defparam pcie_internal_1_1_1.BAR1ADDRWIDTH = BAR1ADDRWIDTH;
defparam pcie_internal_1_1_1.BAR1EXIST = BAR1EXIST;
defparam pcie_internal_1_1_1.BAR1IOMEMN = BAR1IOMEMN;
defparam pcie_internal_1_1_1.BAR1MASKWIDTH = BAR1MASKWIDTH;
defparam pcie_internal_1_1_1.BAR1PREFETCHABLE = BAR1PREFETCHABLE;
defparam pcie_internal_1_1_1.BAR2ADDRWIDTH = BAR2ADDRWIDTH;
defparam pcie_internal_1_1_1.BAR2EXIST = BAR2EXIST;
defparam pcie_internal_1_1_1.BAR2IOMEMN = BAR2IOMEMN;
defparam pcie_internal_1_1_1.BAR2MASKWIDTH = BAR2MASKWIDTH;
defparam pcie_internal_1_1_1.BAR2PREFETCHABLE = BAR2PREFETCHABLE;
defparam pcie_internal_1_1_1.BAR3ADDRWIDTH = BAR3ADDRWIDTH;
defparam pcie_internal_1_1_1.BAR3EXIST = BAR3EXIST;
defparam pcie_internal_1_1_1.BAR3IOMEMN = BAR3IOMEMN;
defparam pcie_internal_1_1_1.BAR3MASKWIDTH = BAR3MASKWIDTH;
defparam pcie_internal_1_1_1.BAR3PREFETCHABLE = BAR3PREFETCHABLE;
defparam pcie_internal_1_1_1.BAR4ADDRWIDTH = BAR4ADDRWIDTH;
defparam pcie_internal_1_1_1.BAR4EXIST = BAR4EXIST;
defparam pcie_internal_1_1_1.BAR4IOMEMN = BAR4IOMEMN;
defparam pcie_internal_1_1_1.BAR4MASKWIDTH = BAR4MASKWIDTH;
defparam pcie_internal_1_1_1.BAR4PREFETCHABLE = BAR4PREFETCHABLE;
//defparam pcie_internal_1_1_1.BAR5ADDRWIDTH = 0;
defparam pcie_internal_1_1_1.BAR5EXIST = BAR5EXIST;
defparam pcie_internal_1_1_1.BAR5IOMEMN = BAR5IOMEMN;
defparam pcie_internal_1_1_1.BAR5MASKWIDTH = BAR5MASKWIDTH;
defparam pcie_internal_1_1_1.BAR5PREFETCHABLE = BAR5PREFETCHABLE;
defparam pcie_internal_1_1_1.CAPABILITIESPOINTER = CAPABILITIESPOINTER;
defparam pcie_internal_1_1_1.CARDBUSCISPOINTER = CARDBUSCISPOINTER;
defparam pcie_internal_1_1_1.CLASSCODE = CLASSCODE;
defparam pcie_internal_1_1_1.CLKDIVIDED = CLKDIVIDED;
defparam pcie_internal_1_1_1.CONFIGROUTING = 3'h1;
defparam pcie_internal_1_1_1.DEVICECAPABILITYENDPOINTL0SLATENCY = DEVICECAPABILITYENDPOINTL0SLATENCY;
defparam pcie_internal_1_1_1.DEVICECAPABILITYENDPOINTL1LATENCY = DEVICECAPABILITYENDPOINTL1LATENCY;
defparam pcie_internal_1_1_1.DEVICEID = DEVICEID;
defparam pcie_internal_1_1_1.DEVICESERIALNUMBER = DEVICESERIALNUMBER;
defparam pcie_internal_1_1_1.DSNBASEPTR = DSNBASEPTR;
defparam pcie_internal_1_1_1.DSNCAPABILITYNEXTPTR = DSNCAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.DUALCOREENABLE = "FALSE";
defparam pcie_internal_1_1_1.DUALCORESLAVE = "FALSE";
defparam pcie_internal_1_1_1.DUALROLECFGCNTRLROOTEPN = 0;
defparam pcie_internal_1_1_1.EXTCFGCAPPTR = 8'h0;
defparam pcie_internal_1_1_1.EXTCFGXPCAPPTR = 12'h0;
defparam pcie_internal_1_1_1.HEADERTYPE = 8'h0;
defparam pcie_internal_1_1_1.INFINITECOMPLETIONS = INFINITECOMPLETIONS;
defparam pcie_internal_1_1_1.INTERRUPTPIN = INTERRUPTPIN;
defparam pcie_internal_1_1_1.ISSWITCH = "FALSE";
defparam pcie_internal_1_1_1.L0SEXITLATENCY = L0SEXITLATENCY;
defparam pcie_internal_1_1_1.L0SEXITLATENCYCOMCLK = L0SEXITLATENCYCOMCLK;
defparam pcie_internal_1_1_1.L1EXITLATENCY = L1EXITLATENCY;
defparam pcie_internal_1_1_1.L1EXITLATENCYCOMCLK = L1EXITLATENCYCOMCLK;
defparam pcie_internal_1_1_1.LINKCAPABILITYASPMSUPPORT = LINKCAPABILITYASPMSUPPORT;
defparam pcie_internal_1_1_1.LINKCAPABILITYMAXLINKWIDTH = LINKCAPABILITYMAXLINKWIDTH;
defparam pcie_internal_1_1_1.LINKSTATUSSLOTCLOCKCONFIG = LINKSTATUSSLOTCLOCKCONFIG;
defparam pcie_internal_1_1_1.LLKBYPASS = "FALSE";
defparam pcie_internal_1_1_1.LOWPRIORITYVCCOUNT = LOWPRIORITYVCCOUNT;
defparam pcie_internal_1_1_1.MSIBASEPTR = MSIBASEPTR;
defparam pcie_internal_1_1_1.MSICAPABILITYMULTIMSGCAP = MSICAPABILITYMULTIMSGCAP;
defparam pcie_internal_1_1_1.MSICAPABILITYNEXTPTR = MSICAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.PBBASEPTR = PBBASEPTR;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0BASEPOWER = PBCAPABILITYDW0BASEPOWER;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0DATASCALE = PBCAPABILITYDW0DATASCALE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0PMSTATE = PBCAPABILITYDW0PMSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0PMSUBSTATE = PBCAPABILITYDW0PMSUBSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0POWERRAIL = PBCAPABILITYDW0POWERRAIL;
defparam pcie_internal_1_1_1.PBCAPABILITYDW0TYPE = PBCAPABILITYDW0TYPE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1BASEPOWER = PBCAPABILITYDW1BASEPOWER;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1DATASCALE = PBCAPABILITYDW1DATASCALE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1PMSTATE = PBCAPABILITYDW1PMSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1PMSUBSTATE = PBCAPABILITYDW1PMSUBSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1POWERRAIL = PBCAPABILITYDW1POWERRAIL;
defparam pcie_internal_1_1_1.PBCAPABILITYDW1TYPE = PBCAPABILITYDW1TYPE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2BASEPOWER = PBCAPABILITYDW2BASEPOWER;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2DATASCALE = PBCAPABILITYDW2DATASCALE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2PMSTATE = PBCAPABILITYDW2PMSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2PMSUBSTATE = PBCAPABILITYDW2PMSUBSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2POWERRAIL = PBCAPABILITYDW2POWERRAIL;
defparam pcie_internal_1_1_1.PBCAPABILITYDW2TYPE = PBCAPABILITYDW2TYPE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3BASEPOWER = PBCAPABILITYDW3BASEPOWER;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3DATASCALE = PBCAPABILITYDW3DATASCALE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3PMSTATE = PBCAPABILITYDW3PMSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3PMSUBSTATE = PBCAPABILITYDW3PMSUBSTATE;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3POWERRAIL = PBCAPABILITYDW3POWERRAIL;
defparam pcie_internal_1_1_1.PBCAPABILITYDW3TYPE = PBCAPABILITYDW3TYPE;
defparam pcie_internal_1_1_1.PBCAPABILITYNEXTPTR = PBCAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.PBCAPABILITYSYSTEMALLOCATED = PBCAPABILITYSYSTEMALLOCATED;
defparam pcie_internal_1_1_1.PCIECAPABILITYINTMSGNUM = 5'h0;
defparam pcie_internal_1_1_1.PCIECAPABILITYNEXTPTR = PCIECAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.PCIECAPABILITYSLOTIMPL = "FALSE";
defparam pcie_internal_1_1_1.PCIEREVISION = 1;
defparam pcie_internal_1_1_1.PMBASEPTR = PMBASEPTR;
defparam pcie_internal_1_1_1.PMCAPABILITYAUXCURRENT = PMCAPABILITYAUXCURRENT;
defparam pcie_internal_1_1_1.PMCAPABILITYD1SUPPORT = PMCAPABILITYD1SUPPORT;
defparam pcie_internal_1_1_1.PMCAPABILITYD2SUPPORT = PMCAPABILITYD2SUPPORT;
defparam pcie_internal_1_1_1.PMCAPABILITYDSI = PMCAPABILITYDSI;
defparam pcie_internal_1_1_1.PMCAPABILITYNEXTPTR = PMCAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.PMCAPABILITYPMESUPPORT = PMCAPABILITYPMESUPPORT;
defparam pcie_internal_1_1_1.PMDATA0 = PMDATA0;
defparam pcie_internal_1_1_1.PMDATA1 = PMDATA1;
defparam pcie_internal_1_1_1.PMDATA2 = PMDATA2;
defparam pcie_internal_1_1_1.PMDATA3 = PMDATA3;
defparam pcie_internal_1_1_1.PMDATA4 = PMDATA4;
defparam pcie_internal_1_1_1.PMDATA5 = PMDATA5;
defparam pcie_internal_1_1_1.PMDATA6 = PMDATA6;
defparam pcie_internal_1_1_1.PMDATA7 = PMDATA7;
defparam pcie_internal_1_1_1.PMDATA8 = 8'h0;
defparam pcie_internal_1_1_1.PMDATASCALE0 = PMDATASCALE0;
defparam pcie_internal_1_1_1.PMDATASCALE1 = PMDATASCALE1;
defparam pcie_internal_1_1_1.PMDATASCALE2 = PMDATASCALE2;
defparam pcie_internal_1_1_1.PMDATASCALE3 = PMDATASCALE3;
defparam pcie_internal_1_1_1.PMDATASCALE4 = PMDATASCALE4;
defparam pcie_internal_1_1_1.PMDATASCALE5 = PMDATASCALE5;
defparam pcie_internal_1_1_1.PMDATASCALE6 = PMDATASCALE6;
defparam pcie_internal_1_1_1.PMDATASCALE7 = PMDATASCALE7;
defparam pcie_internal_1_1_1.PMDATASCALE8 = 0;
defparam pcie_internal_1_1_1.PMSTATUSCONTROLDATASCALE = 2'h0;
defparam pcie_internal_1_1_1.PORTVCCAPABILITYEXTENDEDVCCOUNT = PORTVCCAPABILITYEXTENDEDVCCOUNT;
defparam pcie_internal_1_1_1.PORTVCCAPABILITYVCARBCAP = PORTVCCAPABILITYVCARBCAP;
defparam pcie_internal_1_1_1.PORTVCCAPABILITYVCARBTABLEOFFSET = PORTVCCAPABILITYVCARBTABLEOFFSET;
defparam pcie_internal_1_1_1.RAMSHARETXRX = "FALSE";
defparam pcie_internal_1_1_1.RESETMODE = RESETMODE;
defparam pcie_internal_1_1_1.RETRYRAMREADLATENCY = RETRYRAMREADLATENCY;
defparam pcie_internal_1_1_1.RETRYRAMSIZE = RETRYRAMSIZE;
defparam pcie_internal_1_1_1.RETRYRAMWIDTH = 0;
defparam pcie_internal_1_1_1.RETRYRAMWRITELATENCY = RETRYRAMWRITELATENCY;
defparam pcie_internal_1_1_1.RETRYREADADDRPIPE = "FALSE";
defparam pcie_internal_1_1_1.RETRYREADDATAPIPE = "FALSE";
defparam pcie_internal_1_1_1.RETRYWRITEPIPE = "FALSE";
defparam pcie_internal_1_1_1.REVISIONID = REVISIONID;
defparam pcie_internal_1_1_1.RXREADADDRPIPE = "FALSE";
defparam pcie_internal_1_1_1.RXREADDATAPIPE = "FALSE";
defparam pcie_internal_1_1_1.RXWRITEPIPE = "FALSE";
defparam pcie_internal_1_1_1.SELECTASMODE = "FALSE";
defparam pcie_internal_1_1_1.SELECTDLLIF = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYATTBUTTONPRESENT = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYATTINDICATORPRESENT = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYHOTPLUGCAPABLE = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYHOTPLUGSURPRISE = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYMSLSENSORPRESENT = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYPHYSICALSLOTNUM = 13'h0;
defparam pcie_internal_1_1_1.SLOTCAPABILITYPOWERCONTROLLERPRESENT = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYPOWERINDICATORPRESENT = "FALSE";
defparam pcie_internal_1_1_1.SLOTCAPABILITYSLOTPOWERLIMITSCALE = 2'h0;
defparam pcie_internal_1_1_1.SLOTCAPABILITYSLOTPOWERLIMITVALUE = 8'h0;
defparam pcie_internal_1_1_1.SLOTIMPLEMENTED = "FALSE";
defparam pcie_internal_1_1_1.SUBSYSTEMID = SUBSYSTEMID;
defparam pcie_internal_1_1_1.SUBSYSTEMVENDORID = SUBSYSTEMVENDORID;
defparam pcie_internal_1_1_1.TLRAMREADLATENCY = TLRAMREADLATENCY;
defparam pcie_internal_1_1_1.TLRAMWIDTH = 0;
defparam pcie_internal_1_1_1.TLRAMWRITELATENCY = TLRAMWRITELATENCY;
defparam pcie_internal_1_1_1.TXREADADDRPIPE = "FALSE";
defparam pcie_internal_1_1_1.TXREADDATAPIPE = "FALSE";
defparam pcie_internal_1_1_1.TXTSNFTS = TXTSNFTS;
defparam pcie_internal_1_1_1.TXTSNFTSCOMCLK = TXTSNFTSCOMCLK;
defparam pcie_internal_1_1_1.TXWRITEPIPE = "FALSE";
defparam pcie_internal_1_1_1.UPSTREAMFACING = "TRUE";
defparam pcie_internal_1_1_1.VC0RXFIFOBASEC = VC0RXFIFOBASEC;
defparam pcie_internal_1_1_1.VC0RXFIFOBASENP = VC0RXFIFOBASENP;
defparam pcie_internal_1_1_1.VC0RXFIFOBASEP = VC0RXFIFOBASEP;
defparam pcie_internal_1_1_1.VC0RXFIFOLIMITC = VC0RXFIFOLIMITC;
defparam pcie_internal_1_1_1.VC0RXFIFOLIMITNP = VC0RXFIFOLIMITNP;
defparam pcie_internal_1_1_1.VC0RXFIFOLIMITP = VC0RXFIFOLIMITP;
defparam pcie_internal_1_1_1.VC0TOTALCREDITSCD = VC0TOTALCREDITSCD;
defparam pcie_internal_1_1_1.VC0TOTALCREDITSCH = VC0TOTALCREDITSCH;
defparam pcie_internal_1_1_1.VC0TOTALCREDITSNPH = VC0TOTALCREDITSNPH;
defparam pcie_internal_1_1_1.VC0TOTALCREDITSPD = VC0TOTALCREDITSPD;
defparam pcie_internal_1_1_1.VC0TOTALCREDITSPH = VC0TOTALCREDITSPH;
defparam pcie_internal_1_1_1.VC0TXFIFOBASEC = VC0TXFIFOBASEC;
defparam pcie_internal_1_1_1.VC0TXFIFOBASENP = VC0TXFIFOBASENP;
defparam pcie_internal_1_1_1.VC0TXFIFOBASEP = VC0TXFIFOBASEP;
defparam pcie_internal_1_1_1.VC0TXFIFOLIMITC = VC0TXFIFOLIMITC;
defparam pcie_internal_1_1_1.VC0TXFIFOLIMITNP = VC0TXFIFOLIMITNP;
defparam pcie_internal_1_1_1.VC0TXFIFOLIMITP = VC0TXFIFOLIMITP;
defparam pcie_internal_1_1_1.VC1RXFIFOBASEC = VC1RXFIFOBASEC;
defparam pcie_internal_1_1_1.VC1RXFIFOBASENP = VC1RXFIFOBASENP;
defparam pcie_internal_1_1_1.VC1RXFIFOBASEP = VC1RXFIFOBASEP;
defparam pcie_internal_1_1_1.VC1RXFIFOLIMITC = VC1RXFIFOLIMITC;
defparam pcie_internal_1_1_1.VC1RXFIFOLIMITNP = VC1RXFIFOLIMITNP;
defparam pcie_internal_1_1_1.VC1RXFIFOLIMITP = VC1RXFIFOLIMITP;
defparam pcie_internal_1_1_1.VC1TOTALCREDITSCD = VC1TOTALCREDITSCD;
defparam pcie_internal_1_1_1.VC1TOTALCREDITSCH = VC1TOTALCREDITSCH;
defparam pcie_internal_1_1_1.VC1TOTALCREDITSNPH = VC1TOTALCREDITSNPH;
defparam pcie_internal_1_1_1.VC1TOTALCREDITSPD = VC1TOTALCREDITSPD;
defparam pcie_internal_1_1_1.VC1TOTALCREDITSPH = VC1TOTALCREDITSPH;
defparam pcie_internal_1_1_1.VC1TXFIFOBASEC = VC1TXFIFOBASEC;
defparam pcie_internal_1_1_1.VC1TXFIFOBASENP = VC1TXFIFOBASENP;
defparam pcie_internal_1_1_1.VC1TXFIFOBASEP = VC1TXFIFOBASEP;
defparam pcie_internal_1_1_1.VC1TXFIFOLIMITC = VC1TXFIFOLIMITC;
defparam pcie_internal_1_1_1.VC1TXFIFOLIMITNP = VC1TXFIFOLIMITNP;
defparam pcie_internal_1_1_1.VC1TXFIFOLIMITP = VC1TXFIFOLIMITP;
defparam pcie_internal_1_1_1.VCBASEPTR = VCBASEPTR;
defparam pcie_internal_1_1_1.VCCAPABILITYNEXTPTR = VCCAPABILITYNEXTPTR;
defparam pcie_internal_1_1_1.VENDORID = VENDORID;
defparam pcie_internal_1_1_1.XLINKSUPPORTED = "FALSE";
defparam pcie_internal_1_1_1.XPBASEPTR = XPBASEPTR;
defparam pcie_internal_1_1_1.XPDEVICEPORTTYPE = XPDEVICEPORTTYPE;
defparam pcie_internal_1_1_1.XPMAXPAYLOAD = XPMAXPAYLOAD;
defparam pcie_internal_1_1_1.XPRCBCONTROL = 0;

endmodule
